/*
FILE:     BasePairParameter_global.h
*/
/*
VERSION:  11.200
*/
/*
DATE:     4/20/2024
*/
/*
  Comments and Questions to: sw-help@rcsb.rutgers.edu
*/
/*
COPYRIGHT 1999-2024 Rutgers - The State University of New Jersey

This software is provided WITHOUT WARRANTY OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE OR ANY OTHER WARRANTY, EXPRESS OR
IMPLIED.  RUTGERS MAKE NO REPRESENTATION OR WARRANTY THAT THE
SOFTWARE WILL NOT INFRINGE ANY PATENT, COPYRIGHT OR OTHER
PROPRIETARY RIGHT.

The user of this software shall indemnify, hold harmless and defend
Rutgers, its governors, trustees, officers, employees, students,
agents and the authors against any and all claims, suits,
losses, liabilities, damages, costs, fees, and expenses including
reasonable attorneys' fees resulting from or arising out of the
use of this software.  This indemnification shall include, but is
not limited to, any and all claims alleging products liability.
*/
/*
               RCSB PDB SOFTWARE LICENSE AGREEMENT

BY CLICKING THE ACCEPTANCE BUTTON OR INSTALLING OR USING 
THIS "SOFTWARE, THE INDIVIDUAL OR ENTITY LICENSING THE  
SOFTWARE ("LICENSEE") IS CONSENTING TO BE BOUND BY AND IS 
BECOMING A PARTY TO THIS AGREEMENT.  IF LICENSEE DOES NOT 
AGREE TO ALL OF THE TERMS OF THIS AGREEMENT
THE LICENSEE MUST NOT INSTALL OR USE THE SOFTWARE.

1. LICENSE AGREEMENT

This is a license between you ("Licensee") and the Protein Data Bank (PDB) 
at Rutgers, The State University of New Jersey (hereafter referred to 
as "RUTGERS").   The software is owned by RUTGERS and protected by 
copyright laws, and some elements are protected by laws governing 
trademarks, trade dress and trade secrets, and may be protected by 
patent laws. 

2. LICENSE GRANT

RUTGERS grants you, and you hereby accept, non-exclusive, royalty-free 
perpetual license to install, use, modify, prepare derivative works, 
incorporate into other computer software, and distribute in binary 
and source code format, or any derivative work thereof, together with 
any associated media, printed materials, and on-line or electronic 
documentation (if any) provided by RUTGERS (collectively, the "SOFTWARE"), 
subject to the following terms and conditions: (i) any distribution 
of the SOFTWARE shall bind the receiver to the terms and conditions 
of this Agreement; (ii) any distribution of the SOFTWARE in modified 
form shall clearly state that the SOFTWARE has been modified from 
the version originally obtained from RUTGERS.  

2. COPYRIGHT; RETENTION OF RIGHTS.  

The above license grant is conditioned on the following: (i) you must 
reproduce all copyright notices and other proprietary notices on any 
copies of the SOFTWARE and you must not remove such notices; (ii) in 
the event you compile the SOFTWARE, you will include the copyright 
notice with the binary in such a manner as to allow it to be easily 
viewable; (iii) if you incorporate the SOFTWARE into other code, you 
must provide notice that the code contains the SOFTWARE and include 
a copy of the copyright notices and other proprietary notices.  All 
copies of the SOFTWARE shall be subject to the terms of this Agreement.  

3. NO MAINTENANCE OR SUPPORT; TREATMENT OF ENHANCEMENTS 

RUTGERS is under no obligation whatsoever to: (i) provide maintenance 
or support for the SOFTWARE; or (ii) to notify you of bug fixes, patches, 
or upgrades to the features, functionality or performance of the 
SOFTWARE ("Enhancements") (if any), whether developed by RUTGERS 
or third parties.  If, in its sole discretion, RUTGERS makes an 
Enhancement available to you and RUTGERS does not separately enter 
into a written license agreement with you relating to such bug fix, 
patch or upgrade, then it shall be deemed incorporated into the SOFTWARE 
and subject to this Agreement. You are under no obligation whatsoever 
to provide any Enhancements to RUTGERS or the public that you may 
develop over time; however, if you choose to provide your Enhancements 
to RUTGERS, or if you choose to otherwise publish or distribute your 
Enhancements, in source code form without contemporaneously requiring 
end users or RUTGERS to enter into a separate written license agreement 
for such Enhancements, then you hereby grant RUTGERS a non-exclusive,
royalty-free perpetual license to install, use, modify, prepare
derivative works, incorporate into the SOFTWARE or other computer
software, distribute, and sublicense your Enhancements or derivative
works thereof, in binary and source code form.

4. FEES.  There is no license fee for the SOFTWARE.  If Licensee
wishes to receive the SOFTWARE on media, there may be a small charge
for the media and for shipping and handling.  Licensee is
responsible for any and all taxes.

5. TERMINATION.  Without prejudice to any other rights, Licensor
may terminate this Agreement if Licensee breaches any of its terms
and conditions.  Upon termination, Licensee shall destroy all
copies of the SOFTWARE.

6. PROPRIETARY RIGHTS.  Title, ownership rights, and intellectual
property rights in the Product shall remain with RUTGERS.  Licensee 
acknowledges such ownership and intellectual property rights and will 
not take any action to jeopardize, limit or interfere in any manner 
with RUTGERS' ownership of or rights with respect to the SOFTWARE.  
The SOFTWARE is protected by copyright and other intellectual 
property laws and by international treaties.  Title and related 
rights in the content accessed through the SOFTWARE is the property 
of the applicable content owner and is protected by applicable law.  
The license granted under this Agreement gives Licensee no rights to such
content.

7. DISCLAIMER OF WARRANTY.  THE SOFTWARE IS PROVIDED FREE OF 
CHARGE, AND, THEREFORE, ON AN "AS IS" BASIS, WITHOUT WARRANTY OF 
ANY KIND, INCLUDING WITHOUT LIMITATION THE WARRANTIES THAT IT 
IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE 
OR NON-INFRINGING.  THE ENTIRE RISK AS TO THE QUALITY AND 
PERFORMANCE OF THE SOFTWARE IS BORNE BY LICENSEE.  SHOULD THE 
SOFTWARE PROVE DEFECTIVE IN ANY RESPECT, THE LICENSEE AND NOT 
LICENSOR ASSUMES THE ENTIRE COST OF ANY SERVICE AND REPAIR.  
THIS DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL PART OF 
THIS AGREEMENT.  NO USE OF THE PRODUCT IS AUTHORIZED HEREUNDER 
EXCEPT UNDER THIS DISCLAIMER.

8. LIMITATION OF LIABILITY.  TO THE MAXIMUM EXTENT PERMITTED BY
APPLICABLE LAW,  IN NO EVENT WILL LICENSOR BE LIABLE FOR ANY 
INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING 
OUT OF THE USE OF OR INABILITY TO USE THE SOFTWARE, INCLUDING, 
WITHOUT LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK 
STOPPAGE, COMPUTER FAILURE OR MALFUNCTION, OR ANY AND ALL 
OTHER COMMERCIAL DAMAGES OR LOSSES, EVEN IF ADVISED OF THE
POSSIBILITY THEREOF. 
*/
#ifndef _H_BASE_PAIR_PARAMETER_GLOBAL_H_
#define _H_BASE_PAIR_PARAMETER_GLOBAL_H_

#define HBOND_TYPE_0    0
#define HBOND_TYPE_1    1
#define HBOND_TYPE_2    2
#define HBOND_TYPE_3    3
#define HBOND_TYPE_4    4
#define HBOND_TYPE_5    5
#define HBOND_TYPE_6    6
#define HBOND_TYPE_7    7
#define HBOND_TYPE_8    8
#define HBOND_TYPE_9    9
#define HBOND_TYPE_10  10
#define HBOND_TYPE_11  11
#define HBOND_TYPE_12  12
#define HBOND_TYPE_13  13
#define HBOND_TYPE_14  14
#define HBOND_TYPE_15  15
#define HBOND_TYPE_16  16
#define HBOND_TYPE_17  17
#define HBOND_TYPE_18  18
#define HBOND_TYPE_19  19
#define HBOND_TYPE_20  20
#define HBOND_TYPE_21  21
#define HBOND_TYPE_22  22
#define HBOND_TYPE_23  23
#define HBOND_TYPE_24  24
#define HBOND_TYPE_25  25
#define HBOND_TYPE_26  26
#define HBOND_TYPE_27  27
#define HBOND_TYPE_28  28
#define HBOND_TYPE_29  29

#define WATSON    1
#define HOOGSTEEN 2
#define SUGAR     3

typedef struct {
        char atom[4];
        int  edge; /* WCE=1, CHE=2, SE=4 */
} _Atom_Edge;

typedef struct {
        int  num;
        _Atom_Edge _atoms[6];
} _Base_Edge;

typedef struct {
        int n_donor, n_acceptor;
        char donor[4][4];
        char acceptor[9][4];
        int  donor_type[4];
        int  acceptor_type[9];
} _Donor_Acceptor;

typedef struct {
        char type[2];
        _Donor_Acceptor *da;
        _Base_Edge *be;
} _DONOR_ACCEPTOR;

static _Base_Edge _EA = {
        6,
       {{ "C2", 5 },
        { "N1", 1 },
        { "N3", 4 },
        { "N6", 3 },
        { "N7", 2 },
        { "O2'",4 }}
};

static _Base_Edge _EC = {
       6,
       {{ "C5", 2 },
        { "C6", 2 },
        { "N3", 1 },
        { "N4", 3 },
        { "O2", 5 },
        { "O2'",4 }}
};

static _Base_Edge _EG = {
       6,
       {{ "N1", 1 },
        { "N2", 5 },
        { "N3", 4 },
        { "N7", 2 },
        { "O6", 3 },
        { "O2'",4 }}
};

static _Base_Edge _EI = {
       6,
       {{ "C2", 5 },
        { "N1", 1 },
        { "N3", 4 },
        { "N7", 2 },
        { "O6", 3 },
        { "O2'",4 }}
};

static _Base_Edge _ET = {
       5,
       {{ "C6", 2 },
        { "N3", 1 },
        { "O2", 5 },
        { "O2'",4 },
        { "O4", 3 }}
};

static _Base_Edge _EU = {
       6,
       {{ "C5", 2 },
        { "C6", 2 },
        { "N3", 1 },
        { "O2", 5 },
        { "O2'",4 },
        { "O4", 3 }}
};

static _Donor_Acceptor _baseA = {
        // 3, 9,
        3, 4,
        { "N6", "O2'", "C2" },
        { "N1", "N3",  "N7", "O2'", "O3'", "O4'", "O5'", "OP1", "OP2" },
        { 3, 1, 0 },
        { 3, 3, 3, 1, 1, 1, 1, 1, 1 }
};

static _Donor_Acceptor _baseC = {
        // 4, 8,
        4, 3,
        { "N4", "O2'", "C5", "C6" }, 
        { "O2", "N3", "O2'", "O3'", "O4'", "O5'", "OP1", "OP2" },
        { 3, 1, 0, 0 },
        { 3, 3, 1, 1, 1, 1, 1, 1 }
};

static _Donor_Acceptor _baseG = {
        // 3, 9,
        3, 4,
        { "N1", "N2", "O2'" },
        { "N3", "O6", "N7", "O2'", "O3'", "O4'", "O5'", "OP1", "OP2" },
        { 3, 3, 1 },
        { 3, 3, 3, 1, 1, 1, 1, 1, 1 }
};

static _Donor_Acceptor _baseI = {
        // 3,  9,
        3, 4,
        { "N1", "O2'", "C2" },
        { "N3", "O6", "N7", "O2'", "O3'", "O4'", "O5'", "OP1", "OP2" },
        { 3, 1, 0 },
        { 3, 3, 3, 1, 1, 1, 1, 1, 1 }
};

static _Donor_Acceptor _baseT = {
        // 3, 7,
        3, 3,
        { "N3", "O2'", "C6" },
        { "O2", "O4", "O3'", "O4'", "O5'", "OP1", "OP2" },
        { 3, 1, 0 },
        { 3, 3, 1, 1, 1, 1, 1 }
};

static _Donor_Acceptor _baseU = {
        // 4, 8, 
        4, 3,
        { "N3", "O2'", "C5", "C6" },
        { "O2", "O4", "O2'", "O3'", "O4'", "O5'", "OP1", "OP2" },
        { 3, 1, 0, 0 },
        { 3, 3, 1, 1, 1, 1, 1, 1 }
};

#define NUM_BASE_TYPE        6

static _DONOR_ACCEPTOR _base_type[NUM_BASE_TYPE] = {
       { "A", &_baseA, &_EA },
       { "C", &_baseC, &_EC },
       { "G", &_baseG, &_EG },
       { "I", &_baseI, &_EI },
       { "T", &_baseT, &_ET },
       { "U", &_baseU, &_EU }
};

typedef struct {
        char a_atomtyp[4];
        char b_atomtyp[4];
} ATOM_PAIR;

typedef struct {
        int type;
        int num;
        ATOM_PAIR atom_pair[3];
} BASE_TYPE;

typedef struct {
        int  num_base_type;
        BASE_TYPE base_type[6];
} BASEPAIR_TYPE;

typedef struct {
        char type[7];
        BASEPAIR_TYPE *btype;
} BASE_HBOND_TYPE;

static BASEPAIR_TYPE _base_AA = {
       4, {
       { HBOND_TYPE_1, 2, 
         {{"N6", "N1"},
          {"N1", "N6"}}
       },
       { HBOND_TYPE_2, 2,
         {{"N6", "N7"},
          {"N7", "N6"}}
       },
       { HBOND_TYPE_5, 2,
         {{"N6", "N1"},
          {"N7", "N6"}}
       },
       { HBOND_TYPE_5, 2,
         {{"N1", "N6"},
          {"N6", "N7"}}
       } }
};

static BASEPAIR_TYPE _base_AC = {
       2, {
       { HBOND_TYPE_25, 2,
         {{"N6", "N3"},
          {"N7", "N4"}}
       },
       { HBOND_TYPE_26, 2,
         {{"N6", "N3"},
          {"N1", "N4"}}
       } }
};

static BASEPAIR_TYPE _base_AG = {
       4, {
       { HBOND_TYPE_8, 2,
         {{"N6", "O6"},
          {"N1", "N1"}}
       },
       { HBOND_TYPE_9, 2,
         {{"N6", "O6"},
          {"N7", "N1"}}
       },
       { HBOND_TYPE_10, 2,
         {{"N1", "N2"},
          {"N6", "N3"}}
       },
       { HBOND_TYPE_11, 2,
         {{"N6", "N3"},
          {"N7", "N2"}}
       } }
};

static BASEPAIR_TYPE _base_AI = {
       2, {
       { HBOND_TYPE_8, 2,
         {{"N6", "O6"},
          {"N1", "N1"}}
       },
       { HBOND_TYPE_9, 2,
         {{"N6", "O6"},
          {"N7", "N1"}}
       } }
};

static BASEPAIR_TYPE _base_AT = {
       4, {
       { HBOND_TYPE_20, 2,
         {{"N1", "N3"},
          {"N6", "O4"}}
       },
       { HBOND_TYPE_21, 2,
         {{"N1", "N3"},
          {"N6", "O2"}}
       },
       { HBOND_TYPE_23, 2,
         {{"N7", "N3"},
          {"N6", "O4"}}
       },
       { HBOND_TYPE_24, 2,
         {{"N7", "N3"},
          {"N6", "O2"}}
       } }
};

static BASEPAIR_TYPE _base_CC = {
       2, {
       { HBOND_TYPE_14, 2,
         {{"N3", "N4"},
          {"N4", "N3"}}
       },
       { HBOND_TYPE_15, 2,
         {{"O2", "N4"},
          {"N4", "O2"}}
       } }
};

static BASEPAIR_TYPE _base_CG = {
       2, {
       { HBOND_TYPE_19, 3,
         {{"O2", "N2"},
          {"N3", "N1"},
          {"N4", "O6"}}
       },
       { HBOND_TYPE_22, 2,
         {{"O2", "N1"},
          {"N3", "N2"}}
       } }
};

static BASEPAIR_TYPE _base_CI = {
       1, {
       { HBOND_TYPE_29, 2,
         {{"N3", "N1"},
          {"N4", "O6"}}
       } }
};

static BASEPAIR_TYPE _base_CT = {
       2, {
       { HBOND_TYPE_17, 2,
         {{"N3", "N3"},
          {"N4", "O2"}}
       },
       { HBOND_TYPE_18, 2,
         {{"N3", "N3"},
          {"N4", "O4"}}
       } }
};

static BASEPAIR_TYPE _base_GG = {
       6, {
       { HBOND_TYPE_3, 2,
         {{"O6", "N1"},
          {"N1", "O6"}}
       },
       { HBOND_TYPE_4, 2,
         {{"N3", "N2"},
          {"N2", "N3"}}
       },
       { HBOND_TYPE_6, 2,
         {{"O6", "N1"},
          {"N7", "N2"}}
       },
       { HBOND_TYPE_6, 2,
         {{"N1", "O6"},
          {"N2", "N7"}}
       },
       { HBOND_TYPE_7, 2,
         {{"O6", "N2"},
          {"N7", "N1"}}
       },
       { HBOND_TYPE_7, 2,
         {{"N2", "O6"},
          {"N1", "N7"}}
       } }
};

static BASEPAIR_TYPE _base_GI = {
       3, {
       { HBOND_TYPE_3, 2,
         {{"O6", "N1"},
          {"N1", "O6"}}
       },
       { HBOND_TYPE_6, 2,
         {{"N1", "O6"},
          {"N2", "N7"}}
       },
       { HBOND_TYPE_7, 2,
         {{"N2", "O6"},
          {"N1", "N7"}}
       } }
};

static BASEPAIR_TYPE _base_GT = {
       2, {
       { HBOND_TYPE_27, 2,
         {{"O6", "N3"},
          {"N1", "O4"}}
       },
       { HBOND_TYPE_28, 2,
         {{"O6", "N3"},
          {"N1", "O2"}}
       } }
};

static BASEPAIR_TYPE _base_II = {
       1, {
       { HBOND_TYPE_3, 2,
         {{"N1", "O6"},
          {"O6", "N1"}}
       } }
};

static BASEPAIR_TYPE _base_TT = {
       4, {
       { HBOND_TYPE_12, 2,
         {{"N3", "O4"},
          {"O4", "N3"}}
       },
       { HBOND_TYPE_13, 2,
         {{"O2", "N3"},
          {"N3", "O2"}}
       },
       { HBOND_TYPE_16, 2,
         {{"N3", "O4"},
          {"O2", "N3"}}
       },
       { HBOND_TYPE_16, 2,
         {{"O4", "N3"},
          {"N3", "O2"}}
       } }
};

#define NUM_BASE_HBOND_TYPE  21


static BASE_HBOND_TYPE _base_hbond_type[NUM_BASE_HBOND_TYPE] = {
     { "AA", &_base_AA },
     { "AC", &_base_AC },
     { "AG", &_base_AG },
     { "AI", &_base_AI },
     { "AT", &_base_AT },
     { "AU", &_base_AT },
     { "CC", &_base_CC },
     { "CG", &_base_CG },
     { "CI", &_base_CI },
     { "CT", &_base_CT },
     { "CU", &_base_CT },
     { "GG", &_base_GG },
     { "GI", &_base_GI },
     { "GT", &_base_GT },
     { "GU", &_base_GT },
     { "II", &_base_II },
     { "IT", &_base_GT },
     { "IU", &_base_GT },
     { "TT", &_base_TT },
     { "TU", &_base_TT },
     { "UU", &_base_TT }
};

static std::map<std::string, int> _base_type_index;
static std::map<std::string, int> _base_hbond_type_index;

#endif
